
function DoAnnotationText()
{
	var pointpicker = moi.ui.createPointPicker();

	var projecttocplane = false;
	try {
		projecttocplane = moi.command.getOption( 'DimProjectToCPlane', true );
		moi.ui.commandUI.ProjectToCPlane.value = projecttocplane;
	} catch(e) {}

	if ( projecttocplane )
		pointpicker.projectToCPlane = true;

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
			break;

		if ( pointpicker.event == 'ProjectToCPlane' )
		{
			projecttocplane = moi.ui.commandUI.ProjectToCPlane.value;
			pointpicker.projectToCPlane = projecttocplane;
		}
	}

	var factory = moi.command.createFactory( 'annotationtext' );
	factory.setInput( 0, pointpicker.ptFrame );
	factory.update();

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'BasePtPrompt' );
	moi.ui.showUI( 'OptionsPrompt' );
	moi.ui.hideUI( 'Options' );
	moi.ui.hideUI( 'done' );
	moi.ui.hideUI( 'cancel' );
	moi.ui.endUIUpdate();


	var dlg = moi.ui.createDialog( 'moi://commands/AnnotationTextDialog.htm?type=text&titleid=AnnotationText options prompt', 'resizeable,defaultWidth:26em,defaultHeight:18em', moi.ui.mainWindow );
	dlg.htmlWindow.g_Factory = factory;

	if ( dlg.window.doModal() == -1 )
	    return;

	factory.commit();

	moi.command.setOption( 'DimProjectToCPlane', projecttocplane, true );
}

DoAnnotationText();
